/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingRequestResolver
extends AbstractBuildingDependentRequestResolver<IDeliverable> {
    public BuildingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (building instanceof BuildingWareHouse || !building.getCitizenForRequest((IToken<?>)request.getId()).isPresent()) {
            return false;
        }
        Predicate<ItemStack> pred = itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack).booleanValue() || !((IDeliverable)request.getRequest()).matches((ItemStack)itemStack)) {
                return false;
            }
            if (!request.hasParent()) {
                return true;
            }
            IRequest<?> requestParent = manager.getRequestForToken((IToken<?>)request.getParent());
            return requestParent.getRequestOfType(IDeliverable.class).map(d -> d.matches((ItemStack)itemStack)).orElse(false) == false;
        };
        return InventoryUtils.getCountFromBuilding((IBuilding)building, pred) > 0;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        Set<ICapabilityProvider> tileEntities = this.getCapabilityProviders(manager, building);
        int totalRequested = request.getRequest().getCount();
        int totalAvailable = 0;
        for (ICapabilityProvider iCapabilityProvider : tileEntities) {
            List<ItemStack> inv = InventoryUtils.filterProvider(iCapabilityProvider, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            for (ItemStack stack : inv) {
                if (stack.func_190926_b()) continue;
                totalAvailable += stack.func_190916_E();
            }
        }
        for (Map.Entry entry : building.reservedStacks().entrySet()) {
            if (!request.getRequest().matches(((ItemStorage)entry.getKey()).getItemStack())) continue;
            totalAvailable = Math.max(0, totalAvailable - (Integer)entry.getValue());
            break;
        }
        if (totalAvailable >= totalRequested) {
            return Lists.newArrayList();
        }
        if (totalAvailable >= request.getRequest().getMinimumCount()) {
            return Lists.newArrayList();
        }
        int totalRemainingRequired = totalRequested - totalAvailable;
        IDeliverable iDeliverable = request.getRequest().copyWithCount(totalRemainingRequired);
        return Lists.newArrayList((Object[])new IToken[]{manager.createRequest(this, iDeliverable)});
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        Set<ICapabilityProvider> tileEntities = this.getCapabilityProviders(manager, building);
        int total = request.getRequest().getCount();
        int current = 0;
        ArrayList<ItemStack> deliveries = new ArrayList<ItemStack>();
        for (ICapabilityProvider tile : tileEntities) {
            List<ItemStack> inv = InventoryUtils.filterProvider(tile, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            for (ItemStack stack : inv) {
                if (stack.func_190926_b() || current >= total) continue;
                deliveries.add(stack);
                current += stack.func_190916_E();
            }
        }
        request.addDelivery(deliveries);
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().field_72995_K) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @NotNull
    private Set<ICapabilityProvider> getCapabilityProviders(@NotNull IRequestManager manager, @NotNull AbstractBuilding building) {
        HashSet tileEntities = Sets.newHashSet();
        tileEntities.add(building.getTileEntity());
        tileEntities.removeIf(Objects::isNull);
        return tileEntities;
    }
}

